$LogFile = "C:\ProgramData\WaaS\WaaS_PostActions.log" #Default if one isn't specified in Task Sequence
$RegistryPath = "HKLM:SOFTWARE\WaaS"
$CurrentBuild = Get-ItemPropertyValue "HKLM:\SOFTWARE\Microsoft\Windows NT\CurrentVersion" 'ReleaseId' -ErrorAction SilentlyContinue
$WaaSParentKeysPath = 'HKLM:\SOFTWARE\WaaS'
$WaaSParentKeys = Get-Item $WaaSParentKeysPath
$WaaSParentBuildNumber = $WaaSParentKeys.GetValue('LastOSUpgradeTo')
$WaaSKeyCurrent = get-item "$WaaSParentKeysPath\$WaaSParentBuildNumber"
$WaaSStage = $WaaSKeyCurrent.GetValue('WaaS_Stage')


function Test-RegistryValue
{
    <# 
    .SYNOPSIS 
    Tests if a registry value exists. 
     
    .DESCRIPTION 
    The usual ways for checking if a registry value exists don't handle when a value simply has an empty or null value. This function actually checks if a key has a value with a given name. 
     
    .EXAMPLE 
    Test-RegistryKeyValue -Path 'hklm:\Software\Carbon\Test' -Name 'Title' 
     
    Returns `True` if `hklm:\Software\Carbon\Test` contains a value named 'Title'. `False` otherwise. 
    #>
    [CmdletBinding()]
    param(
        [Parameter(Mandatory=$true)]
        [string]
        # The path to the registry key where the value should be set. Will be created if it doesn't exist.
        $Path,
        
        [Parameter(Mandatory=$true)]
        [string]
        # The name of the value being set.
        $Name
    )
    
    Set-StrictMode -Version 'Latest'

    #Use-CallerPreference -Cmdlet $PSCmdlet -Session $ExecutionContext.SessionState

    if( -not (Test-Path -Path $Path -PathType Container) )
    {
        return $false
    }
    
    $properties = Get-ItemProperty -Path $Path 
    if( -not $properties )
    {
        return $false
    }
    
    $member = Get-Member -InputObject $properties -Name $Name
    if( $member )
    {
        return $true
    }
    else
    {
        return $false
    }
}

#region: CMTraceLog Function formats logging in CMTrace style
        function CMTraceLog {
         [CmdletBinding()]
    Param (
		    [Parameter(Mandatory=$false)]
		    $Message,
 
		    [Parameter(Mandatory=$false)]
		    $ErrorMessage,
 
		    [Parameter(Mandatory=$false)]
		    $Component = $env:computername,
 
		    [Parameter(Mandatory=$false)]
		    [int]$Type,
		
		    [Parameter(Mandatory=$true)]
		    $LogFile
	    )
    <#
    Type: 1 = Normal, 2 = Warning (yellow), 3 = Error (red)
    #>
	    $Time = Get-Date -Format "HH:mm:ss.ffffff"
	    $Date = Get-Date -Format "MM-dd-yyyy"
 
	    if ($ErrorMessage -ne $null) {$Type = 3}
	    if ($Component -eq $null) {$Component = " "}
	    if ($Type -eq $null) {$Type = 1}
 
	    $LogMessage = "<![LOG[$Message $ErrorMessage" + "]LOG]!><time=`"$Time`" date=`"$Date`" component=`"$Component`" context=`"`" type=`"$Type`" thread=`"`" file=`"`">"
	    $LogMessage | Out-File -Append -Encoding UTF8 -FilePath $LogFile
    }
if (((Test-RegistryValue -Path "$RegistryPath" -Name "CustomLogPreFix") -eq $true) -and ((Test-RegistryValue -Path "$RegistryPath" -Name "CustomLogPath") -eq $true))
    {
    $CustomLogPath = Get-ItemPropertyValue -Path $RegistryPath -Name "CustomLogPath" -ErrorAction SilentlyContinue
    $CustomLogPreFix = Get-ItemPropertyValue -Path $RegistryPath -Name "CustomLogPreFix" -ErrorAction SilentlyContinue
    $LogFile = "$CustomLogPath\$($CustomLogPreFix)_PostActions.log"
    }

CMTraceLog -Message  "---Starting LegalNotice-UpgradeComplete Script---" -Type 1 -LogFile $LogFile -Component LegalText-IPUSuccess
CMTraceLog -Message  "  WaaS_Stage: $WaaSStage" -Type 1 -LogFile $LogFile -Component LegalText-IPUSuccess

if ((Test-RegistryValue -Path "$RegistryPath" -Name "LegalText_DefaultIsEnabled") -eq $true)
    {
    $LegalText_DefaultIsEnabled = Get-ItemPropertyValue -Path $RegistryPath -Name "LegalText_DefaultIsEnabled"
    CMTraceLog -Message  "  LegalText_DefaultIsEnabled: $LegalText_DefaultIsEnabled" -Type 1 -LogFile $LogFile -Component LegalText-IPUSuccess
    }

if ((Test-RegistryValue -Path "$RegistryPath" -Name "LegalText_EnableMods") -eq $true)
    {
    $LegalText_EnableMods = Get-ItemPropertyValue -Path $RegistryPath -Name "LegalText_EnableMods"
    CMTraceLog -Message  "  LegalText_EnableMods: $LegalText_EnableMods" -Type 1 -LogFile $LogFile -Component LegalText-IPUSuccess
    if ($LegalText_EnableMods -eq $true)
        {
        CMTraceLog -Message  "  LegalText_DefaultIsEnabled: $LegalText_DefaultIsEnabled" -Type 1 -LogFile $LogFile -Component LegalText-IPUSuccess
        CMTraceLog -Message  "  Grabbing Legal Text from $RegistryPath | LegalText_SuccessCaption & LegalText_SuccessText " -Type 1 -LogFile $LogFile -Component LegalText-IPUSuccess
        $legalnoticecaption = Get-ItemPropertyValue -Path $RegistryPath -Name "LegalText_SuccessCaption"
        CMTraceLog -Message  "  LegalText_SuccessCaption: $legalnoticecaption" -Type 1 -LogFile $LogFile -Component LegalText-IPUSuccess
        $legalnoticetext = Get-ItemPropertyValue -Path $RegistryPath -Name "LegalText_SuccessText"
        CMTraceLog -Message  "  LegalText_SuccessText: $legalnoticetext" -Type 1 -LogFile $LogFile -Component LegalText-IPUSuccess
        }
    }


if ($LegalText_EnableMods -eq $true)
    {
    if ($WaaSStage -eq "Deployment_Success")
        {   
        CMTraceLog -Message  " Updating Legal Text because Deployment Successful" -Type 1 -LogFile $LogFile -Component LegalText-IPUSuccess
        $CurrentLegalCaption = Get-ItemPropertyValue 'HKLM:\Software\Microsoft\Windows\CurrentVersion\Policies\System' 'legalnoticecaption' -ErrorAction SilentlyContinue
        CMTraceLog -Message  "LegalCaption Data Currently: $CurrentLegalCaption" -Type 1 -LogFile $LogFile -Component LegalText-IPUSuccess
        Set-ItemProperty -Path 'HKLM:\Software\Microsoft\Windows\CurrentVersion\Policies\System' -Name legalnoticecaption -Value $legalnoticecaption
        Set-ItemProperty -Path 'HKLM:\Software\Microsoft\Windows\CurrentVersion\Policies\System' -Name legalnoticetext -Value $legalnoticetext
        $CurrentLegalCaption = Get-ItemPropertyValue 'HKLM:\Software\Microsoft\Windows\CurrentVersion\Policies\System' 'legalnoticecaption' -ErrorAction SilentlyContinue
        CMTraceLog -Message  "LegalCaption Data Currently: $CurrentLegalCaption" -Type 1 -LogFile $LogFile -Component LegalText-IPUSuccess
        CMTraceLog -Message  "Updated Values: legalnoticecaption & legalnoticetext" -Type 1 -LogFile $LogFile -Component LegalText-IPUSuccess
        #Unregister-ScheduledTask -TaskName SetLegalNoticeText-OSUpgradeComplete -Confirm:$false
        #CMTraceLog -Message  "Removed Scheduled Task SetLegalNoticeText-OSUpgradeComplete" -Type 1 -LogFile $LogFile -Component LegalText-IPUSuccess
    
        }
    else
        {
        CMTraceLog -Message  "  Doing Nothing, Deployment NOT Successful" -Type 1 -LogFile $LogFile -Component LegalText-IPUSuccess
        }
    }
else
    {
    CMTraceLog -Message  "  Legal Text Modifications Disabled in TS, skipping changes" -Type 1 -LogFile $LogFile -Component LegalText-IPUSuccess
    }
CMTraceLog -Message  "---Exiting LegalNotice-UpgradeComplete Script---" -Type 1 -LogFile $LogFile -Component LegalText-IPUSuccess